$TITLE Hanford Waste Problem - LP formulation

$ONTEXT
This file was modified by Amit Goyal and Urmila Diwekar,2000-2001
$OFFTEXT


SETS

  Mstr master set of all elements
            /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  Comp(Mstr) input file waste components and parameters
            /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  C(Mstr)  all waste components tracked
            /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet/
  I(Mstr)  waste components for glass property models
           /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3, ZrO2, Other/;



PARAMETERS

  MW(Mstr) Mass of each component in the waste;


SCALAR

  TMWG     Total mass of oxides (in kg) in waste;


POSITIVE VARIABLES

  MG(Mstr)  Mass of each component in the glass
  MF(Mstr)  Mass of each component in the frit
  FG(Mstr)  Mass fraction of each component in glass
  FF(Mstr)  Mass fraction of each component in frit
  Glass     Total mass of glass formed
  Wastefrac Fraction of waste in glass;


FREE VARIABLE

 TMFG       Total mass of frit required;


$include "wastcomplp1.prn"
$include "blendcalc.inc"
$include "bounds.inc"


EQUATIONS

  Fritreq       Total amount of frit required - minimized variable
  GlassMass     Glass = waste + frit
  GlassComp(C)  calculate mass of individual components in the glass
  Crystal1      glass crystallinity constraint
  Crystal2      glass crystallinity constraint
  Crystal3      glass crystallinity constraint
  Crystal4      glass crystallinity constraint
  Crystal5      glass crystallinity constraint
  GlassMB       Glass = sum of mass of individual components
  SiO2LO        Component Bounds
  B2O3LO
  Na2OLO
  Li2OLO
  Fe2O3LO
  OtherLO
  SiO2HI
  B2O3HI
  Na2OHI
  Li2OHI
  CaOHI
  MgOHI
  Fe2O3HI
  Al2O3HI
  ZrO2HI
  OtherHI
  Cr2O3HI
  FHI
  P2O5HI
  SO3HI
  NobmetHI ;




Fritreq ..     TMFG =E= SUM(C,MF(C));

GlassMass ..   TMFG + TMWG =E= Glass;

GlassComp(C).. MG(C) =E= MF(C) + MW(C);

Crystal1 ..    MG('SiO2') =G= MG('Al2O3')* C1;

Crystal2 ..    MG('MgO')+ MG('CaO') =L= C2 * Glass;

Crystal3 ..    MG('Fe2O3')+ MG('Al2O3')+ MG('ZrO2')+ MG('Other') =L= C3* Glass;

Crystal4 ..    MG('Al2O3')+ MG('ZrO2') =L= C4 * Glass;

Crystal5 ..    MG('MgO')+MG('CaO')+MG('ZrO2') =L= C5 * Glass;

GlassMB  ..    Glass =E= SUM(I, MG(I));

SiO2LO   ..    MG('SiO2') =G= 0.42* Glass;

B2O3LO   ..    MG('B2O3') =G= 0.05 * Glass;

Na2OLO   ..    MG('Na2O') =G= 0.05 * Glass;

Li2OLO   ..    MG('Li2O') =G= 0.01 * Glass;

Fe2O3LO  ..    MG('Fe2O3')=G= 0.0 * Glass;

OtherLO  ..    MG('Other')=G= 0.0 * Glass;

SiO2HI   ..    MG('SiO2') =L= 0.57* Glass;

B2O3HI   ..    MG('B2O3') =L= 0.20* Glass;

Na2OHI   ..    MG('Na2O') =L= 0.20* Glass;

Li2OHI   ..    MG('Li2O') =L= 0.07* Glass;

CaOHI    ..    MG('CaO')  =L= 0.10* Glass;

MgOHI    ..    MG('MgO')  =L= 0.08* Glass;

Fe2O3HI  ..    MG('Fe2O3')=L= 0.15* Glass;

Al2O3HI  ..    MG('Al2O3')=L= 0.15* Glass;

ZrO2HI   ..    MG('ZrO2') =L= 0.13* Glass;

OtherHI  ..    MG('Other')=L= 0.10* Glass;

Cr2O3HI  ..    MG('Cr2O3')=L= 0.005* Glass;

FHI      ..    MG('F')    =L= 0.017* Glass;

P2O5HI   ..    MG('P2O5') =L= 0.01* Glass;

SO3HI    ..    MG('SO3')  =L= 0.005* Glass;

NOBMETHI ..    MG('Nobmet')=L= 0.025* Glass;

MODEL NUCWASTE /ALL/


$include "calculate.inc"